import React from 'react';
import { shell } from 'electron';
import StyledButton from 'components/StyledButton';
import downloadSignError from 'resources/images/download-sign-error.svg';
import useStyles from './styles';
import { CARDO_UPDATE_DOWNLOAD_URL } from '../../../constants/urls';

type Props = {
    strings: object
};

function ManualDownloadScreen({ strings }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.downloadingUpdateContainer}>
            <img
                className={classes.updateAvailableIcon}
                src={downloadSignError}
                alt="Download error icon"
            />
            <div className={classes.updateAvailableTitle}>
                {strings.update_application_error}
            </div>
            <div className={classes.updateAvailableSubtitle}>
                {strings.manual_download_description}
            </div>
            <StyledButton
                variant="contained"
                btnSize="big"
                onClick={() => shell.openExternal(CARDO_UPDATE_DOWNLOAD_URL)}
            >
                {strings.download}
            </StyledButton>
        </div>
    );
}

export default ManualDownloadScreen;
